import java.io.*;
import java.awt.*;
import java.util.*;

public class Fabrica {
    static Color color;

    public static Figura getTetaedro( float ancho, float alto, float largo ){
        Vector3D[] vertices = new Vector3D[4];
        vertices[0] = new Vector3D((float)(-(ancho/2)), (float)(alto/2), (float)(-(largo/2)));
        vertices[1] = new Vector3D((float)(ancho/2), (float)(alto/2), (float)(-(largo/2)));
        vertices[2] = new Vector3D((float)(ancho/2), (float)(alto/2), (float)(largo/2));
        vertices[3] = new Vector3D((float)(-(ancho/2)), (float)(alto/2), (float)(largo/2));

        Cara cara = new Cara( vertices );
        cara.estilo = Cara.FILL_MALLA;
        cara.colorRelleno = Color.pink;
        Vector caras = new Vector();
        caras.addElement(cara);

        Vector3D[] vertices2 = new Vector3D[4];
        vertices2[0] = new Vector3D((float)(-(ancho/2)), (float)(alto/2), (float)(largo/2));
        vertices2[1] = new Vector3D((float)(ancho/2), (float)(alto/2), (float)(largo/2));
        vertices2[2] = new Vector3D((float)(ancho/2), (float)(-(alto/2)), (float)(largo/2));
        vertices2[3] = new Vector3D((float)(-(ancho/2)), (float)(-(alto/2)), (float)(largo/2));
        Cara cara2 = new Cara( vertices2 );
        cara2.estilo = Cara.FILL_MALLA;
        cara2.colorRelleno = Color.cyan;
        caras.addElement( cara2 );

        Vector3D[] vertices3 = new Vector3D[4];
        vertices3[0] = new Vector3D((float)(-(ancho/2)), (float)(alto/2), (float)(-(largo/2)));
        vertices3[1] = new Vector3D((float)(-(ancho/2)), (float)(alto/2), (float)(largo/2));
        vertices3[2] = new Vector3D((float)(-(ancho/2)), (float)(-(alto/2)), (float)(largo/2));
        vertices3[3] = new Vector3D((float)(-(ancho/2)), (float)(-(alto/2)), (float)(-(largo/2)));
        Cara cara3 = new Cara( vertices3 );
        cara3.estilo = Cara.FILL_MALLA;
        cara3.colorRelleno = Color.green;
        caras.addElement( cara3 );

        Vector3D[] vertices4 = new Vector3D[4];
        vertices4[0] = new Vector3D((float)(ancho/2), (float)(alto/2), (float)(-(largo/2)));
        vertices4[1] = new Vector3D((float)(-(ancho/2)), (float)(alto/2), (float)(-(largo/2)));
        vertices4[2] = new Vector3D((float)(-(ancho/2)), (float)(-(alto/2)), (float)(-(largo/2)));
        vertices4[3] = new Vector3D((float)(ancho/2), (float)(-(alto/2)), (float)(-(largo/2)));
        Cara cara4 = new Cara( vertices4 );
        cara4.estilo = Cara.FILL_MALLA;
        cara4.colorRelleno = Color.magenta;
        caras.addElement( cara4 );

        Vector3D[] vertices5 = new Vector3D[4];
        vertices5[0] = new Vector3D((float)(ancho/2), (float)(alto/2), (float)(largo/2));
        vertices5[1] = new Vector3D((float)(ancho/2), (float)(alto/2), (float)(-(largo/2)));
        vertices5[2] = new Vector3D((float)(ancho/2), (float)(-(alto/2)), (float)(-(largo/2)));
        vertices5[3] = new Vector3D((float)(ancho/2), (float)(-(alto/2)), (float)(largo/2));
        Cara cara5 = new Cara( vertices5 );
        cara5.estilo = Cara.FILL_MALLA;
        cara5.colorRelleno = Color.orange;
        caras.addElement( cara5 );

        Vector3D[] vertices6 = new Vector3D[4];
        vertices6[0] = new Vector3D((float)(-(ancho/2)), (float)(-(alto/2)), (float)(largo/2));
        vertices6[1] = new Vector3D((float)(ancho/2), (float)(-(alto/2)), (float)(largo/2));
        vertices6[2] = new Vector3D((float)(ancho/2), (float)(-(alto/2)), (float)(-(largo/2)));
        vertices6[3] = new Vector3D((float)(-(ancho/2)), (float)(-(alto/2)), (float)(-(largo/2)));
        Cara cara6 = new Cara( vertices6 );
        cara6.estilo = Cara.FILL_MALLA;
        cara6.colorRelleno = Color.yellow;
        caras.addElement( cara6 );


        return new Figura( caras );
    }


    public static Figura getCubo( float dimension ){
        return getTetaedro( dimension, dimension, dimension ) ;
    }

    public static Figura getRomboedro( Figura plantilla ) { //no funciona todavia
        return plantilla;
    }

    private static Vector3D[] getCara( Vector lineas, float largo){
        
        Vector3D[] vectores3D = new Vector3D[lineas.size() - 2];
        color = Color.red;
        
        for(int n=0; n<lineas.size(); n++){
            String linea = (String)lineas.elementAt(n);
            //System.out.println("linea[" + n +"]=" + linea);
            if( linea.startsWith("color:") ){
                 StringTokenizer st = new StringTokenizer( linea, ",");
                 String s1 = st.nextToken();
                 String s2 = st.nextToken();
                 String s3 = st.nextToken();
                 color = 
                     new Color(
                         Integer.parseInt( s1.substring(7) ) ,
                         Integer.parseInt( s2 ) ,
                         Integer.parseInt( s3.substring(0,s3.length()-1) ) );

                
            } else if( !linea.startsWith("-") ){
                StringTokenizer st = new StringTokenizer( linea, ",");
                String s1 = st.nextToken();
                String s2 = st.nextToken();
                //System.out.println( s1 + "=" + s1.substring(1) );
                //System.out.println( s2 + "=" + s2.substring(0,s2.length()-1) );
                vectores3D[n] =
                    new Vector3D( 
                        Float.parseFloat(s1.substring(1)),
                        Float.parseFloat(s2.substring(0,s2.length()-1)),
                        (float)(largo/2) );
            }
        }

        return vectores3D;
    }

    public static Mundo getMundo( File fichero, float largo ){
        Mundo mundo = new Mundo();
        Vector lineas = leerLineas( fichero );
        Vector cacho = new Vector();
        for( int n=0; n<lineas.size(); n++){
            String linea = (String)lineas.elementAt(n);
            cacho.addElement( linea );

            if( linea.startsWith("-") ) {

               


                Figura figura = getCosa( cacho, largo );
                mundo.addFigura( figura );
                cacho = new Vector();
            }
        }

        return mundo;
    }


    public static Vector leerLineas( File fichero ){
        Vector lineas = new Vector();
        try{

            BufferedReader in = new BufferedReader(  new FileReader( fichero ) );
            String linea;

            
            while ( (linea=in.readLine()) != null ) {
                lineas.addElement( linea );
                Salida.salida("Fabrica.getCosa().." + linea);
            }

            in.close();
        } catch (Exception e) { e.printStackTrace(); }

        return lineas;
    }

    public static Figura getCosa( Vector lineas, float largo ){
       
        Figura figura = null;

        Vector caras = new Vector();

        //cara 1:
        Vector3D[] vectores3D = getCara(lineas, largo);

        //el centro de la figura
        String linea = (String)lineas.elementAt(lineas.size() - 1);
        StringTokenizer st = new StringTokenizer( linea, ",");
        String s1 = st.nextToken();
        String s2 = st.nextToken();
        Point centro = 
            new Point(
                Integer.parseInt( s1.substring(2) ),
                Integer.parseInt( s2.substring(0,s2.length()-1) ) );



        Cara cara1 = new Cara( vectores3D ) ;
        cara1.colorRelleno = new Color( color.getRed(), color.getGreen(), color.getBlue() );

        caras.addElement( cara1 );

        //cara 2: (la 1 pero dibujada al reves y con z nefativa)
        Vector3D[] vectores3D2 = new Vector3D[vectores3D.length];
        int nn = vectores3D.length - 1;
        for(int n=0; n<vectores3D.length; n++){
            //System.out.print( n+"," );
            vectores3D2[nn--] = 
                new Vector3D(
                    vectores3D[n].x,
                    vectores3D[n].y,
                    -vectores3D[n].z );
        }
        Cara cara2 = new Cara( vectores3D2 ) ;
        cara2.colorRelleno = new Color( color.getRed(), color.getGreen(), color.getBlue()  );

        caras.addElement( cara2 );

        //caras 3... fin-1
        boolean c = true;
        nn = vectores3D.length - 1;
        for(int n=0; n<vectores3D.length-1; n++){
            Vector3D[] v = new Vector3D[4];
            v[0] = new Vector3D ( vectores3D[n+1] );
            v[1] = new Vector3D ( vectores3D[n] );
            v[2] = new Vector3D ( vectores3D2[nn] );
            v[3] = new Vector3D ( vectores3D2[nn-1] );
            nn--;
            Cara nCara = new Cara(v);
            if( c ){
                nCara.colorRelleno = color.darker();
                c = false;
            } else {
                nCara.colorRelleno = color.brighter();
                c = true;
            }


            caras.addElement( nCara );
        }

        //cara fin:
        Vector3D[] v = new Vector3D[4];
        v[0] = new Vector3D ( vectores3D[0] );
        v[1] = new Vector3D ( vectores3D[vectores3D.length-1] );
        v[2] = new Vector3D ( vectores3D2[0] );
        v[3] = new Vector3D ( vectores3D2[vectores3D2.length-1] );
        Cara nCara = new Cara(v);
        if( c ){
            nCara.colorRelleno = color.darker();
            c = false;
        } else {
            nCara.colorRelleno = color.brighter();
            c = true;
        }
       
        caras.addElement( nCara );


        

        figura = new Figura( caras );
        
        figura.translacion.x = centro.x;
        figura.translacion.y = centro.y;

        return figura;
    }

    public static Figura getCosa( File fichero, float largo){
        return getCosa( leerLineas(fichero), largo );
    }

}